package br.com.tutorial.avalia;

import java.io.File;
import java.io.IOException;

import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.*;

public class Fluxo {

    private String caminho;
    private boolean resposta;
    private int numFluxo;
    private Document document;

    public Fluxo(String caminho, boolean resposta, int numFluxo) {

           this.caminho = caminho;
           this.resposta = resposta;
           this.numFluxo = numFluxo;
    }

    private void init() throws IOException, JDOMException {

           File arqXML = new File(caminho);
           SAXBuilder builder = new SAXBuilder();
	       document = builder.build(arqXML);
    }

    public String direcionarFluxo() {

           String novoEndereco = null;
           String xpath = "";

           try {
               init();
               int numFluxos = totalFluxos();
               if(resposta) {
                    xpath = "//configuracao/pergunta/redirecionar-acerto";
               }
               else {
                    if(numFluxos <= numFluxo) {
                        xpath = "//configuracao/pergunta/fluxos/fluxo[@id='" + ++numFluxo + "']/redirecionar";
                    }
                    else {
                         xpath = "//configuracao/pergunta/redirecionar-erro";
                    }
               }

               XPath endereco = XPath.newInstance(xpath);

               novoEndereco = endereco.valueOf(document);
           }
           catch(IOException e) {
                System.err.println("Falha");
           }
           catch(JDOMException e) {
                System.err.println("Erro!");
           }

           return novoEndereco;
    }

    private int totalFluxos() {

        int numFluxos = 0;

        try {
            XPath endereco = XPath.newInstance("count(//fluxo)");
            numFluxos = Integer.parseInt(endereco.valueOf(document));
        }
        catch(JDOMException e) {
            System.err.println("Erro!");
        }

        return numFluxos;
    }
}