<?xml version="1.0" encoding="ISO-8859-1"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

   <xsl:template match="/">
   
	<html>
		<head>
			<title></title>
			<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
			<link rel="stylesheet" href="../../cssGerais/formatacaoPadrao.css" type="text/css" />
			<script type="text/javascript" src="../../jsGerais/ConfLink.js"></script>
			<script type="text/javascript" src="../../jsGerais/ConfiguracoesNavBar.js"></script>
			<script type="text/javascript" src="../../jsGerais/ControlarCamada.js"></script>
			<script type="text/javascript" src="../../jsGerais/ControlarBarraNavegacao.js"></script>
			<script type="text/javascript" src="../../jsGerais/ControlarBannerPrincipal.js"></script>
			<script type="text/javascript" src="../../xslGerais/js/Util.js"></script>
		</head>
		<xsl:variable name="livro" select="indice/@livro" />
		<xsl:variable name="bannerTipo" select="indice/@bannerTipo" />
		<xsl:variable name="bannerFile" select="indice/@bannerFile" />
		<body onload="mostrarBarra(false), mudarBannerPrincipal('{$bannerTipo}', '../biblioteca/livro{$livro}/{$bannerFile}')">
			<xsl:for-each select="indice/capitulo">
				<p>
					<div class="textoVerPrt11n">- <strong><xsl:value-of select="titulo" /></strong></div><br />
					<div class="textoVerPrt11n"><em><xsl:value-of select="descricao" /></em></div><br />
					<a class="linkVerVrm10n" title="Clique aqui para iniciar o captulo"><xsl:attribute name="href">javascript: configControlNavBar('<xsl:value-of select="caminho-cap" />', '<xsl:value-of select="/indice/@livro" />'), config('<xsl:value-of select="/indice/@livro" />', '<xsl:value-of select="@numero" />')</xsl:attribute>Entrar</a>
					<hr />
				</p>
			</xsl:for-each>
		</body>
	</html>
	  
   </xsl:template>
   
</xsl:stylesheet>